from vcCommand import *
import re
import os.path
import openpyxl
import vcHelpers.Selection


#region Main functions
def first_state():
  # FIRST STATE CREATES THE UI FOR THE USER
  global group, uri_xml_base, base
  global  read_xml_prop, tag_list_path
  # REMOVE EXISTING COMMAND PROPERTIES
  # cmd = getCommand()
  # cmdProps = cmd.Properties
  # READ URI
  uri = getCommandPath()
  base, filename = os.path.split(uri)

  uri_xml_base = os.path.join(base, 'template/ConfigurationBase.xml')
  uri_xml_base = uri_xml_base[8:]

  # CREATE PROPERTIES
  group = 0
  group2 = 0

  tag_list_path = createProperty(VC_URI, 'Tag list file location')
  tag_list_path.Group = group2 = group2 + 500

  server_ip_prop = createProperty(VC_STRING, 'Server IP-Address')
  server_ip_prop.Group = group2 = group2 + 500
  server_ip_prop.Value = "192.168.0.12"
  print("Select Excel file with PLC tags. Each tag should be in a separate row.")
  print("Expected column format: A: Name, C: Data Type, D: Logical Address")
  

  read_xml_prop = createProperty(VC_BUTTON, 'Generate Configuration XML')
  read_xml_prop.Group = group2 = group2 + 500
  read_xml_prop.OnChanged = event_wrapper(server_ip_prop)

  executeInActionPanel() 


#Wrapper because why not
def event_wrapper(server_ip_prop):
  def inner(arg):
    writeXML(server_ip_prop)
  return inner
  

#Creates a XML configuration file
def writeXML(server_ip_prop):
  '''# reads the Excel and generates the configuration file '''
  #Validate Excel file path
  if len(tag_list_path.Value) < 8:
    print "{} is empty.".format(tag_list_path.Name)
    return

  #Read template XML
  text = ""
  with open (uri_xml_base.decode('utf-8'), "r") as template_file:
    text = template_file.read()
  if len(text) == 0:
    print 'Could not read template file.'
    return
  
  print("Reading Excel {}".format(tag_list_path.Value))
  tag_data = read_tag_data(tag_list_path) #Returns raw text data
  if not tag_data:
    print("Could not find any suitable tag data from file.")
    return
  
  tags = parse_tags(tag_data) #Returns a list of Tag objects
  if not tags:
    print "Failed to extract tags from file."
    return
  
  browsing_tags_text = generate_browsing_tags(tags) #For given tags returns a formatted string to create tags for browsing
  if browsing_tags_text is None:
    print "Failed to generate tags for browsing."
    return
  
  #Formats template configuration base file with tag info
  text = text.replace("{IP_ADDRESS_HERE}", server_ip_prop.Value)
  text = text.replace("{BROWSING_TAGS_HERE}", browsing_tags_text)
  print("-"*50)
  print("Added {} PLC variables to the configuration file.".format(len(tags)))
  #Generate connections
  sim_to_server_text , server_to_sim_text = pair_S7_tags(tags)
  text = text.replace("{SIM_TO_SERVER_HERE}", sim_to_server_text)
  text = text.replace("{SERVER_TO_SIM_HERE}", server_to_sim_text)
  #Save the results to a file
  uri_xml = os.path.join(base, "ServerConfiguration.xml")
  uri_xml = uri_xml[8:].decode('utf-8')
  with open (uri_xml, "wb") as outfile:
    outfile.write(text.encode('utf8'))

  print "Configuration file saved to:", uri_xml
  print "Select Import from the Configuration toolbar to select this file."

#endregion

#region Secondary functions
def read_tag_data(tag_list_path):
  #Validate Excel file
  row_data = []
  file_path = tag_list_path.Value[8:].decode('utf-8')
  try:
    wb = openpyxl.load_workbook(file_path)
  except Exception, e:
    print e
    print "Make sure that the Excel file is valid. Close the file if it is currently opened."
    return row_data
  #Iterate through all worksheets and extract row data
  for ws in wb.worksheets:
    for row in ws.rows:
      list_with_values = []
      for cell in row:
        val = cell.value
        if val is not None:
          list_with_values.append(val.encode())
      if len(list_with_values) > 3:
        row_data.append(list_with_values)
      else:
        print "Skipping invalid row", list_with_values
  return row_data


def parse_tags(tag_data):
  #Parse tag_data strings into usable Tag objects
  tags = []
  for tag_info in tag_data:
    tag = Tag()
    tag.symbol_name = tag_info[0]
    tag.data_type = tag_info[2]
    tag.memory_location = tag_info[3]
    #Check that everything has a value
    if not all([tag.symbol_name, tag.data_type, tag.memory_location]):
      print "Skipping invalid row:", tag_info
      continue
    
    #Parse memory location into memory area, byte index and bit index
    if "%" not in tag.memory_location:
      print "Invalid memory address. Address must start with %.", tag_info
      continue
    if tag.memory_location[1] in DATA_AREA_DICT.keys():
      tag.data_area = DATA_AREA_DICT[tag.memory_location[1]]
    else:
      print "Invalid memory address. Failed to parse memory location", tag_info
      continue
    match= re.search(r"(\d+)", tag.memory_location[2:])
    if match:
      tag.byte_index = match.group()
    else:
      print "Invalid memory address. Failed to parse byte index", tag_info
      continue
    if tag.memory_location[-2] == ".": #Set bit index to 0 if it is not separated in the memory address
      tag.bit_index = "0"
    else:
      tag.bit_index = tag.memory_location[-1]
    
    #Validate data type
    tag.server_data_type = tag.data_type
    if tag.data_type.upper() in DATA_TYPES: #Convert standard data types to upper case. Don't convert user defined data types
      tag.data_type = tag.data_type.upper()
    else:
      tag.data_type = "Unknown"
    
    #Determine the data type length
    if tag.data_type in WORD_LENGTHS.keys():
      tag.word_length = WORD_LENGTHS[tag.data_type]
    elif "B" in tag.memory_location:
      tag.word_length = "Byte"
    elif "W" in tag.memory_location:
      tag.word_length = "Word"
    elif "D" in tag.memory_location:
      tag.word_length = "DWord"
    else:
      tag.word_length = "Bit"
    tags.append(tag)
  return tags


def generate_browsing_tags(tags):
  #Generates tags for the browsing functionality so that any modifications can be made manually
  item_text = ""
  first_pass = True
  for tag in tags:
    if first_pass:
      first_pass = False
    else:
      item_text += "\n\t\t\t\t\t\t\t" #Add new line and tab formatting between each item
    temp_text = S7_BROWSING_VALUE_ITEM_TEMPLATE
    item_text += temp_text.format(MemoryLocation = tag.memory_location, BitIndex = tag.bit_index, ByteIndex = tag.byte_index,
                     DataArea = tag.data_area, DataType = tag.data_type, SymbolName = tag.symbol_name,
                     WordLength = tag.word_length, ServerDataType = tag.server_data_type)
  return item_text


def pair_S7_tags(tags):
  #Generate pairing text between S7 Tags and simulation variables
  sim_to_server_text = ""
  server_to_sim_text = ""
  sim_to_server_count = 0
  server_to_sim_count = 0
  sim_vars = SimulationVariables()
  for tag in tags:
    #Attempt to find a behaviour / property / servo DoF from the simulation that matches the tag symbol name
    paired_component = find_tag_pair(tag, sim_vars)
    #Check if no pair was found for this tag
    if None in (paired_component.component_object, paired_component.name):
      #print "No pair found for", tag.symbol_name
      continue
    
    #Servo DoFs have different structure in the XML than other behaviors or properties
    if paired_component.dof is None: 
      variable_template = STANDARD_VARIABLE_TEMPLATE
    else:
      variable_template = DOF_VARIABLE_TEMPLATE
      variable_template = variable_template.format(DOF = paired_component.dof)
    #Populate variable_template with the component information
    variable_template = variable_template.format(ComponentName = paired_component.name,
                                                 BehaviourName = paired_component.behaviour, PropertyName = paired_component.property)
    
    #Set access type so that simulation can only write to PLC Inputs
    if tag.data_area == "Input":
      access_type = "ReadAndWrite"
    else:
      access_type = "Read"
    #Populate connection item template with the info
    temp_text = S7_CONNECTION_ITEM_TEMPLATE
    temp_text = temp_text.format(VariableTemplate=variable_template, BitIndex=tag.bit_index, ByteIndex=tag.byte_index, Access = access_type,
                                 DataArea=tag.data_area, DataType=tag.data_type, SymbolName=tag.symbol_name, WordLength=tag.word_length)
    
    #Inputs are sent from simu to server. Outputs and memory tags come from server to simu
    if tag.data_area == "Input":
      sim_to_server_count += 1
      if sim_to_server_text != "": #Add line break and tabs between each text block
        sim_to_server_text +="\n\t\t\t\t\t\t\t" 
      sim_to_server_text += temp_text
    else:
      server_to_sim_count += 1
      if server_to_sim_text != "": #Add line break and tabs between each text block
        server_to_sim_text +="\n\t\t\t\t\t\t\t" 
      server_to_sim_text += temp_text
  
  if sim_to_server_count or server_to_sim_count:
    print("Automatically paired some variables in the configuration file.")
    print ("Simulation to PLC = {}, \tPLC to Sim = {}, \t Total = {}.".format(sim_to_server_count, server_to_sim_count, sim_to_server_count + server_to_sim_count))
  return sim_to_server_text, server_to_sim_text


def find_tag_pair(tag, sim_vars):
  '''Attempts to find a simulation variable that matches the tag symbol name and type
  1. See if the tag should be connected to a servo Dof.
  2. If no match found, attempt to find a match from behaviour of given tag type.
  3. If no match found, expand search of properties of given type.
  4. If still no match, go through all properties and all behaviours once more to see if any names match'''
  pair = PairedComponent()
  matched_dof = None
  matched_behaviour = None
  matched_property = None
  #Reals
  if tag.data_type == "REAL":
    if "_M" in tag.symbol_name: #Look for servo DoF
      matched_dof = dof_search_helper(sim_vars, tag.symbol_name)
      # if matched_dof is not None:
      #   print "FOUND DOF", matched_dof.Controller.Component.Name, matched_dof.Controller.Name, matched_dof.Name
    if matched_dof is None:
      matched_behaviour = name_iteration_helper(sim_vars.real_signals, tag.symbol_name)
      if matched_behaviour is None:
        matched_property = name_iteration_helper(sim_vars.real_properties, tag.symbol_name)
  #Booleans
  elif tag.data_type == "BOOL" or tag.word_length == "Bit": #word_length is used to match unknown data types
    matched_behaviour = name_iteration_helper(sim_vars.boolean_signals, tag.symbol_name)
    if matched_behaviour is None:
      matched_property = name_iteration_helper(sim_vars.boolean_properties, tag.symbol_name)
  #Integers
  elif tag.data_type in ("BYTE", "WORD", "DWORD", "SINT", "USINT", "INT", "UINT", "DINT", "UDINT"):
    matched_behaviour = name_iteration_helper(sim_vars.integer_signals, tag.symbol_name)
    if matched_behaviour is None:
      matched_property = name_iteration_helper(sim_vars.integer_properties, tag.symbol_name)
  #Go through all behaviour and properties if no match is found from the above type-specific checks
  if not any((matched_dof, matched_behaviour, matched_property)): 
    matched_behaviour = name_iteration_helper(sim_vars.all_behaviours, tag.symbol_name)
    if matched_behaviour is None:
      matched_property = name_iteration_helper(sim_vars.all_properties, tag.symbol_name)
  #See if any matches are found and save the match to a pair
  if matched_dof is not None:
    pair.pair_type = "dof"
    pair.component_object = matched_dof.Controller.Component
    pair.name = matched_dof.Controller.Component.Name
    pair.behaviour = matched_dof.Controller.Name
    pair.dof = matched_dof.Name
    #Based on example files let's assume that property name = dof name. Could also be vcJoint vs vcDof
    pair.property = matched_dof.Name
  elif matched_behaviour is not None:
    pair.pair_type = "beh"
    pair.component_object = matched_behaviour.Component
    pair.name = matched_behaviour.Component.Name
    pair.behaviour = matched_behaviour.Name
    pair.property = NIL_TEMPLATE #Let's see if this is legit or if we need to change the template
  elif matched_property is not None:
    pair.pair_type = "prop"
    pair.component_object = matched_property.Component
    pair.name = matched_property.Component.Name
    pair.property = matched_property.Name
    pair.behaviour = NIL_TEMPLATE
  return pair


#Helper function to attempt to match a real type tag to a simulation DoF
def dof_search_helper(sim_vars, symbol_name):
  matched_dof = name_iteration_helper(sim_vars.all_dofs, symbol_name)
  if matched_dof is not None:
    return matched_dof
  matched_joint = name_iteration_helper(sim_vars.all_joints, symbol_name)
  if matched_joint is not None:
    if matched_joint.Dof is not None:
      return matched_joint.Dof
  #try to guess the correct dof by splitting the component name
  split_result = symbol_name.split("_M")
  component_name_guess = split_result[0]
  dof_name_guess = "M" + split_result[-1]
  if component_name_guess[-1].isalpha(): #Remove the extra letter (module specifier) from the end
    component_name_guess = component_name_guess[:-1]
  matched_component = name_iteration_helper(sim_vars.all_comps, component_name_guess)
  if matched_component is None:
    component_name_guess = component_name_guess.replace("_", " ")
    matched_component = name_iteration_helper(sim_vars.all_comps, component_name_guess)
  if matched_component is None:
    return None
  #print "Found component that matches a guess:", matched_component.Name
  servos = matched_component.findBehavioursByType(VC_SERVOCONTROLLER)
  for s in servos:
    for joint in s.Joints:
      if joint.Dof is not None:
        #if joint.Dof.Name.endswith(dof_name_guess):
        if dof_name_guess in joint.Dof.Name:
          return joint.Dof
        #if joint.Name.endswith(dof_name_guess):
        if dof_name_guess in joint.Name:
          return joint.Dof
  #print "No match found for", matched_component.Name
  return None


#Iterates through a list of behaviours or proeprties and sees if any elements name matches the given symbol name
def name_iteration_helper(iterator, symbol_name):
  for x in iterator:
    if x.Name == symbol_name:
      return x
  return None

#endregion

#region Class definitions
#Class for organizing tag information
class Tag:
  def __init__(self):
    self.memory_location = None
    self.bit_index = None
    self.byte_index = None
    self.data_area = None
    self.data_type = None
    self.symbol_name = None
    self.word_length = None
    self.server_data_type = None

#Class for organizing component information for creating varible pairs
class PairedComponent:
  def __init__(self):
    self.pair_type = None
    self.component_object = None
    self.name = None
    self.behaviour = None
    self.property = None
    self.dof = None

#Class for organizing all simulation variables by type
class SimulationVariables:
  def __init__(self):
    self.all_properties = []
    self.all_comps = vcHelpers.Selection.getAllComponents()
    for c in self.all_comps:
      self.all_properties.extend(c.Properties)
    self.all_behaviours = vcHelpers.Selection.getAllComponentsBehaviours()
    #
    self.all_servos = vcHelpers.Selection.filterBehaviours(self.all_behaviours, VC_SERVOCONTROLLER)
    self.all_joints = []
    for s in self.all_servos:
      self.all_joints.extend(s.Joints)
    self.all_dofs = [x.Dof for x in self.all_joints]
    #
    self.boolean_signals = vcHelpers.Selection.filterBehaviours(self.all_behaviours, VC_BOOLEANSIGNAL)
    self.boolean_properties = [p for p in self.all_properties if p.Type == VC_BOOLEAN]
    #Boolean maps not included. Any boolean map signals that are already connected already have a hidden boolean signal behind an interface
    self.integer_signals = vcHelpers.Selection.filterBehaviours(self.all_behaviours, VC_INTEGERSIGNAL)
    self.integer_properties = [p for p in self.all_properties if p.Type == VC_INTEGER]
    self.real_signals = vcHelpers.Selection.filterBehaviours(self.all_behaviours, VC_REALSIGNAL)
    self.real_properties = [p for p in self.all_properties if p.Type == VC_REAL]
    self.string_signals = vcHelpers.Selection.filterBehaviours(self.all_behaviours, VC_STRINGSIGNAL)
    self.string_properties = [p for p in self.all_properties if p.Type == VC_STRING]
    self.matrix_signals = vcHelpers.Selection.filterBehaviours(self.all_behaviours, VC_MATRIXSIGNAL)
    self.matrix_properties = [p for p in self.all_properties if p.Type == VC_MATRIX]
    self.vector_properties = [p for p in self.all_properties if p.Type == VC_VECTOR]

#endregion

#region String templates
S7_BROWSING_VALUE_ITEM_TEMPLATE = """<S7:S7ValueItem>
                  <S7:Description>{MemoryLocation}</S7:Description>
                  <S7:ItemId>
                    <S7:Access>ReadAndWrite</S7:Access>
                    <S7:BitIndex>{BitIndex}</S7:BitIndex>
                    <S7:ByteIndex>{ByteIndex}</S7:ByteIndex>
                    <S7:DataArea>{DataArea}</S7:DataArea>
                    <S7:DataType>{DataType}</S7:DataType>
                    <S7:SymbolName>{SymbolName}</S7:SymbolName>
                    <S7:WordLength>{WordLength}</S7:WordLength>
                  </S7:ItemId>
                  <S7:ServerDataType>{ServerDataType}</S7:ServerDataType>
                </S7:S7ValueItem>"""

S7_CONNECTION_ITEM_TEMPLATE = """<Array:anyType i:type="VariableGroupItem">
                <DisplayName i:nil="true" />
                <ServerItem i:type="S7:S7VariableID">
                  <S7:Access>{Access}</S7:Access>
                  <S7:BitIndex>{BitIndex}</S7:BitIndex>
                  <S7:ByteIndex>{ByteIndex}</S7:ByteIndex>
                  <S7:DataArea>{DataArea}</S7:DataArea>
                  <S7:DataType>{DataType}</S7:DataType>
                  <S7:SymbolName>{SymbolName}</S7:SymbolName>
                  <S7:WordLength>{WordLength}</S7:WordLength>
                </ServerItem>
                {VariableTemplate}
              </Array:anyType>"""

#For most variables
STANDARD_VARIABLE_TEMPLATE = """<SimulationVariable>
                    <Component>{ComponentName}</Component>
                    <Behaviour>{BehaviourName}</Behaviour>
                    <Property>{PropertyName}</Property>
                  </SimulationVariable>"""

#For variables of type Real that have _M in name
DOF_VARIABLE_TEMPLATE = """<SimulationVariable i:type="SimulationDofVariable">
                    <Component>{{ComponentName}}</Component>
                    <Behaviour>{{BehaviourName}}</Behaviour>
                    <Property>{{PropertyName}}</Property>
                    <DofObject>{DOF}</DofObject>
                  </SimulationVariable>"""


NIL_TEMPLATE = 'i:nil="true"' #Used if behavior or property is empty 
ACCESS_OPTIONS = ["ReadAndWrite", "Read"] #RW for sim to server, R for server to sim
DATA_AREAS = ["Input", "Output", "Memory"]
DATA_TYPES = ["BOOL", "BYTE", "WORD", "DWORD", "SINT", "USINT", "INT", "UINT", "DINT", "UDINT", "REAL", "Unknown"] #Unknown is set for user defined data types
WORD_LENGTHS = {"BOOL" : "Bit", "BYTE" : "Byte", "Word" : "Word", "DWORD" : "DWord", "REAL" : "DWord", "SINT" : "Byte", "USINT" : "Byte", "INT" : "Word", "UINT" : "Word", "DINT" : "DWord", "UDINT" : "DWord"} #
MEMORY_AREA_SHORT = ["I", "Q", "M"] #Input, Output, Memory. For data flow direction, I goes to PLC, Q  and M come from PLC to simulation
DATA_TYPE_SHORT = ["", "B", "W", "D"] #Empty for Bool, B for Byte, W for Word, D for DWord
DATA_AREA_DICT = {MEMORY_AREA_SHORT[i]: DATA_AREAS[i] for i in range(len(MEMORY_AREA_SHORT))}

#endregion

addState(first_state)